@extends('user.layouts.master')
@section('css')
 <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Open+Sans:300,400,600,700">
    <link rel="stylesheet" href="https://www.powerworkerearn.com/resources/css/argon.css" type="text/css">
    <link rel="stylesheet" href="https://www.powerworkerearn.com/resources/css/myapp.css" type="text/css">
    <link rel="stylesheet" href="https://www.powerworkerearn.com/resources/css/bttn.css" type="text/css">
    
    <style>
        .ads-rate-area {
            border: 1px solid #eaeaea;
            display: flex;
            justify-content: space-between;
            padding: 10px;
            border-radius: 4px;
            cursor: pointer;
        }

        .ads-rate-area-active {
            background-color: dodgerblue;
            color: white;
        }
        .custom-file-label-drop {
            border-radius: 5px;
            border: 1px solid #eaeaea;
            padding: 10px;
            background: #f5f1f1;
        }

    </style>

@endsection
@section('user-content')
    @if(session('ads_success'))
        <div class="alert alert-success" style="font-weight:bold;">
            <i class="fas fa-check"></i>
            <span id="adsSuccessMessage" class="ms-3">Ads Post Success</span>
            <button type="button" class="close" onclick="closeTheMessage()">
                <span aria-hidden="true">&times;</span>
            </button>
        </div>
    @endif
    
    @if(session('ads_error'))
        <div class="alert alert-danger" style="font-weight:bold;">
            <i class="far fa-frown"></i>
            <span id="adsErrorMessage" class="ms-2">Insufficient Balance</span>
            <button type="button" class="close" onclick="closeTheMessage()">
                <span aria-hidden="true">&times;</span>
            </button>
        </div>
    @endif
    
    <div class="card mt-2">
        <div class="row justify-content-center">
            <div class="col-md-6">
                <div class="">
                    <div class="card-header">
                        <h4 class="card-title">New Advertisement</h4>
                    </div>
                    <div class="card-body">
                        <form action="{{ route('user.advertisement-store') }}" method="POST" enctype="multipart/form-data">
                            @csrf
                            <div class="">
                                <div class="form-group">
                                    <label for="title" class="form-label">Ads Title </label>
                                    <input class="form-control" type="text" name="title" placeholder="Ads Title" required>
                                </div>
                                <div class="form-group">
                                    <label for="link" class="form-label">Target Destination</label>
                                    <div class="input-group">
                                        <div class="input-group-prepend">
                                            <span class="input-group-text"><i class="fas fa-link"></i></span>
                                        </div>
                                        <input class="form-control" type="text" name="link" value="" placeholder="https://demo.com">
                                    </div>
                                </div>

                                <div class="form-group m-0">
                                    <input class="form-control" type="hidden" name="amount" id="amount" value="" required placeholder="days">
                                    <input class="form-control" type="hidden" name="days" id="days" value="" required placeholder="days">
                                    <div class="row m-0 p-0">
                                        @foreach(ad_banner_rates() as $ad_rate)
                                            <div class="col-6 p-1">
                                                <div class="c-pointer ads-rate-area" id="ads-rate-area-{{$ad_rate->day}}" onclick="selectDuration('{{$ad_rate->day}}', '{{$ad_rate->cost}}')">
                                                    <span><i class="fas fa-ad"></i> {{$ad_rate->day}} Day</span><span>${{$ad_rate->cost}}</span>
                                                </div>
                                            </div>
                                        @endforeach
                                      
                                    </div>
                                </div>
   
                                <p class="font-weight-500 text-blue">*Image resolution max- width (1000px) & max- height (500px) ( allow only jpg , png )</p>
                                <div>
                                   <input type="file" style="display: none" name="image" id="imageInput" accept="image/x-png,image/jpg,image/jpeg" onchange="readURL(this)" lang="en" required>
                                    <small class="text-danger" id="file-error"></small>
                                    
                                    <Image Preview Element>
                                    <img id="imagePreview" style="display: none;" width="100" height="100" />
                                    
                                    <label class="custom-file-label-drop" for="imageInput"><i class="fas fa-camera"></i> Select Banner image </label>
                                </div>
                                <div class="gallery-img mt-2">
                                    <img id="imagePreview" src="#" alt="Image Preview" style="display: none; width: 100%; height: 300px;">
                                </div>
                            </div>
                            <div class="text-right">
                                 <!--<button type="submit" class="btn btn-primary mt-4 mb-0">Submit</button>-->
                                 <button type="button" name="" class="btn btn-outline-info mt-4 bttn" data-toggle="modal" data-target="#modalConfirm"><i class="fas fa-check"></i> Submit</button>
                            </div>
                            <!-- Add modal confirmation dialog -->
                            <div class="modal fade" id="modalConfirm" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
                                <div class="modal-dialog modal-dialog-centered" role="document">
                                    <div class="modal-content">
                                        <div class="modal-body">
                                            <h4 class="text-red">Sir, Please check your Title/Destination link again.</h4>
                                            <br>
                                            <p class="tab-title-header h2">Are you confirm?</p>
                                        </div>
                                        <div class="modal-footer">
                                            <button type="button" class="btn btn-success bttn" data-dismiss="modal" id="btnSubmit">Yes, Confirm</button>
                                            <button type="button" class="btn btn-default" data-dismiss="modal">No</button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <script src="https://code.jquery.com/jquery-3.6.4.min.js"></script>
    
@endsection

@section('js')
<!-- Add jQuery -->
<script src="https://code.jquery.com/jquery-3.6.4.min.js"></script>

<!-- Add Popper.js -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.14.7/umd/popper.min.js" integrity="sha384-UO2eT0CpHqdSJQ6hJty5KVphtPhzWj9WO1clHTMGa3JDZwrnQq4sF86dIHNDz0W1" crossorigin="anonymous"></script>

<!-- Add Bootstrap JS -->
<script src="https://stackpath.bootstrapcdn.com/bootstrap/4.3.1/js/bootstrap.min.js" integrity="sha384-JjSmVgyd0p3pXB1rRibZUAYoIIy6OrQ6VrjIEaFf/nJGzIxFDsf4x0xIM+B07jRM" crossorigin="anonymous"></script>

    <script>
        function setAccount(account_id){
            $('#deposit_account').val(account_id);

            $.ajax({
                url: "{{ route('user.deposit-account-info') }}",
                type:"POST",
                data:{
                    _token: '{{csrf_token()}}',
                    account_id: account_id,
                },
                success:function(data) {
                    $('#deposit_area').show();
                    $('#deposit_account_text').html('Account No: '+data['account_no']);
                    $('#deposit_account_guideline').html(data['guideline']);
                },
            });
        }


        function selectDuration(duration, rate){
            $('#days').val(duration);
            $('#amount').val(rate);
            $('.ads-rate-area').removeClass('ads-rate-area-active');
            $('#ads-rate-area-'+duration).addClass('ads-rate-area-active');
       }
  
        $(document).ready(function () {
        // Triggered when the file input changes
        $('#imageInput').on('change', function () {
            readURL(this);
        });

        // Function to read and display the selected image
        function readURL(input) {
            var fileInput = $(input);
            var previewImg = $('#imagePreview');

            var file = fileInput.get(0).files[0];

            if (file) {
                var reader = new FileReader();

                reader.onload = function () {
                    previewImg.show();
                    previewImg.attr("src", reader.result);
                };

                reader.readAsDataURL(file);
            } else {
                // Hide the image preview if no file is selected
                previewImg.hide();
            }
        }
    });
     
    </script>
    <script>
    document.addEventListener('DOMContentLoaded', function () {
        var confirmButton = document.getElementById('btnSubmit');

        // Attach a click event listener to the confirm button
        confirmButton.addEventListener('click', function () {
            // Find the closest form and submit it when the user confirms
            var form = confirmButton.closest('form');
            if (form) {
                form.submit();
            }
        });
    });
    
    function closeTheMessage() {
        var successMessage = document.getElementById('adsSuccessMessage');
        var errorMessage = document.getElementById('adsErrorMessage');

        if (successMessage) {
            successMessage.parentNode.style.display = 'none';
        }

        if (errorMessage) {
            errorMessage.parentNode.style.display = 'none';
        }
    }
     
   function readURL(input) {
    var file = input.files[0];
    var errorElement = document.getElementById('file-error');
    var preview = document.getElementById('imagePreview');
    
    if (file) {
        // Check file size (max 1MB)
        if (file.size > 1048576) { // 1048576 bytes = 1MB
            errorElement.textContent = "File size must be less than or equal to 1MB.";
            input.value = ''; // Clear the input
            preview.style.display = 'none'; // Hide the image preview
            return;
        } else {
            errorElement.textContent = ""; // Clear error message
        }

        // Show image preview
        var reader = new FileReader();
        reader.onload = function (e) {
            preview.src = e.target.result; // Set the image preview
            preview.style.display = 'block'; // Show the image preview
        }
        reader.readAsDataURL(file);
    }
}

</script>
@endsection